#pragma once


/****************************************************************************
*  CONST DEFINE
****************************************************************************/
#define E_SUCCESS 0

void UnloadDll();


BOOL LoadDll();


#ifdef __cplusplus
#define PRINTER_API extern "C" __declspec( dllimport )
#else
#define PRINTER_WIN32_SDK_API __declspec( dllimport )
#endif

/* Prtprinter */
typedef int (_stdcall *pPrinterCreator)( void**, const char* );
typedef int (_stdcall *pPrinterCreatorS)( char* );
typedef int (_stdcall *pPrinterDestroy)(void*);
typedef int (_stdcall *pPortOpen)( void*, const char* );
typedef int (_stdcall *pPortClose)( void* );
typedef int (_stdcall *pWriteData)(void*, unsigned char[], unsigned int);
typedef int (_stdcall *pReadData)(void*, unsigned char[], unsigned int,unsigned int*);
typedef int (_stdcall *ZPL_GetPrinterDpi)(void*, char*);
typedef int (_stdcall *pDirectIO)( void* , unsigned char [], unsigned int , unsigned char [], unsigned int , unsigned int*  );
typedef int (_stdcall *ZPL_StartFormat)( void* );
typedef int (_stdcall *ZPL_GetPrinterStatus)( void*, int*);
typedef int (_stdcall *ZPL_EndFormat)( void* );
typedef int (_stdcall *ZPL_SetChangeFontEncoding)(void*, int);
typedef int (_stdcall *ZPL_SetVietMode)(void*, int);
typedef int (_stdcall *ZPL_SetVietFontEncoding)(void*);
typedef int (_stdcall *ZPL_SetUserFontName)( void*,char* );
typedef int (_stdcall *ZPL_Text)( void*, int, int, int, int, int, int, char* );
typedef int (_stdcall *ZPL_Text_Block)( void*, int, int, int, int, int, int, int, int, char* );
typedef int (_stdcall *ZPL_BarCode39)( void*, int, int, int, int, int, char, char, char, char* );
typedef int (_stdcall *ZPL_Pdf417)( void*, int, int, int, int, int, int, int, int, char, char* );
typedef int (_stdcall *ZPL_MicroPdf417)( void*, int, int, int, int, int, int, char* );
typedef int (_stdcall *ZPL_SetLabelHome)( void*, int, int);
typedef int (_stdcall *ZPL_SetLabelLength)( void*, int);
typedef int (_stdcall *ZPL_SetTearOffAdjustPosition)( void*, int);
typedef int (_stdcall *ZPL_CodeEan8)( void*, int, int, int, int, int, char, char, char* );
typedef int (_stdcall *ZPL_QRCode)( void*, int, int, int, int, int, char, char,char, char* );
typedef int (_stdcall *ZPL_UpcExtensions)( void*, int, int, int, int, int, char, char, char* );
typedef int (_stdcall *ZPL_UpcaBarcode)( void*, int, int, int, int, int, char, char, char, char* );
typedef int (_stdcall *ZPL_GraphicBox)( void*, int, int, int, int, int, int );
typedef int (_stdcall *ZPL_GraphicCircle)( void*, int, int, int, int );
typedef int (_stdcall *ZPL_GraphicDiagonalLine)( void*, int, int, int, int, int, int );
typedef int (_stdcall *ZPL_GraphicEllipse)( void*, int, int, int, int, int );
typedef int (_stdcall *ZPL_PrintImage)(void*, int, int, char* );
typedef int (_stdcall *ZPL_GraphicSymbol)( void*, int, int, int, int, int, char* );
typedef int (_stdcall *ZPL_SetDiagnosticsMode)( void*, int );
typedef int (_stdcall *ZPL_SetPrintRate)( void*, int, int, int );
typedef int (_stdcall *ZPL_SetPrintDarkness)( void*, int );
typedef int (_stdcall *ZPL_PrintConfigurationLabel)( void* );
typedef int (_stdcall *ZPL_SetSerialCommunications)( void*, int, int, char, int, char );
typedef int (_stdcall *ZPL_SetPrintMode)( void*, char,char );
typedef int (_stdcall *ZPL_SetPrintQuantity)( void*, int, int, int,char );
typedef int (_stdcall *ZPL_RfidWrite)( void*, char, int, int,int,const char* );
typedef int (_stdcall *ZPL_RfidRead)( void*, char, int, int,int,const char*,const char* );
typedef int (_stdcall *ZPL_RfidCalibration)( void* );

extern void	* hprinter;
extern HMODULE	m_Dll;

extern pPrinterCreator			    PrinterCreator;
extern pPrinterCreatorS			    PrinterCreatorS;
extern pPortOpen			        PortOpen;
extern pPortClose			        PortClose;
extern pWriteData                   WriteData;
extern pReadData                    ReadData;
extern pPrinterDestroy			    PrinterDestroy;
extern pDirectIO			        DirectIO;
extern ZPL_GetPrinterDpi            GetPrinterDpi;
extern ZPL_StartFormat			    StartFormat;
extern ZPL_GetPrinterStatus			GetPrinterStatus;
extern ZPL_EndFormat			    EndFormat;
extern ZPL_SetChangeFontEncoding    SetChangeFontEncoding;
extern ZPL_SetVietMode				SetVietMode;
extern ZPL_SetVietFontEncoding		SetVietFontEncoding;
extern ZPL_SetUserFontName			PrintSetUserFontName;
extern ZPL_Text						PrintText;
extern ZPL_Text_Block			    PrintTextBlock;
extern ZPL_BarCode39			    BarCode39;
extern ZPL_Pdf417			        Pdf417;
extern ZPL_MicroPdf417			    MicroPdf417;
extern ZPL_SetLabelHome			    SetLabelHome;
extern ZPL_SetLabelLength			SetLabelLength;
extern ZPL_SetTearOffAdjustPosition	SetTearOffAdjustPosition;
extern ZPL_CodeEan8			        CodeEan8;
extern ZPL_QRCode			        QRCode;
extern ZPL_UpcExtensions		    UpcExtensions;
extern ZPL_UpcaBarcode			    UpcaBarcode;
extern ZPL_GraphicBox			    GraphicBox;
extern ZPL_GraphicCircle		    GraphicCircle;
extern ZPL_GraphicDiagonalLine		GraphicDiagonaline;
extern ZPL_GraphicEllipse		    GraphicEllipse;
extern ZPL_GraphicSymbol		    GraphicSymbol;
extern ZPL_PrintImage               PrintImage;
extern ZPL_SetDiagnosticsMode		SetDiagnosticsMode;
extern ZPL_SetPrintRate			    SetPrintRate;
extern ZPL_SetPrintDarkness		    SetPrintDarkness;
extern ZPL_PrintConfigurationLabel	PrintConfigurationLabel;
extern ZPL_SetSerialCommunications	SetSerialCommunications;
extern ZPL_SetPrintMode				SetPrintMode;
extern ZPL_SetPrintQuantity			SetPrintQuantity;
extern ZPL_RfidWrite			    RfidWrite;
extern ZPL_RfidRead					RfidRead;
extern ZPL_RfidCalibration			RfidCalibration;
